package DTCDemo;

import java.awt.Cursor;

import javax.swing.JOptionPane;

import com.sun.jna.platform.win32.WinNT.HANDLE;

import SDK.SDKlib;
import SDK.SDKlib.Action;
import SDK.SDKlib.Return;

import static DTCDemo.Main.tabbedPane;

//====================================================================================

public class Utils {

	static final String demoVersion = "1.1.4.1";

	static final int MAX_CARD_HEIGHT = 642;
	static final int MAX_Y_COORD     = MAX_CARD_HEIGHT - 1;

	//These are updated in OpenSession once the printer type is determined.  
	//Hence not being 'final'
	static int maxCardLength = 1016;
    static int maxXCoord     = maxCardLength - 1;
	
	static byte connectedPrinter;
	
	//------------------------------------------------------------------------------------

	static String Separator(byte action)               {return action == Action.READ ? ": "      : " -> ";}
	static String OnOffString(Boolean state)           {return state                 ? "On"      : "Off";}
	static String EnabledDisabledString(Boolean state) {return state                 ? "Enabled" : "Disabled";}

	// ------------------------------------------------------------------------------------

	static void CursorWait()    {tabbedPane.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));}
	static void CursorDefault() {tabbedPane.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));}
	
	// ------------------------------------------------------------------------------------

	static void DisplayError(String action, int value) {
		String ErrorString = action + ": ";
		
		switch (value) {
		case Return.TIMEOUT:              ErrorString += "ID_TIMEOUT";             break;
		case Return.ERROR:                ErrorString += "ID_ERROR";               break;
		case Return.PRINTER_ERROR:        ErrorString += "ID_PRINTER_ERROR";       break;
		case Return.DRIVER_NOT_COMPLIANT: ErrorString += "ID_DRIVER_NOTCOMPLIANT"; break;
		case Return.OPEN_PRINTER_ERROR:   ErrorString += "ID_OPENPRINTER_ERROR";   break;
		case Return.REMOTE_COMM_ERROR:    ErrorString += "ID_REMOTECOMM_ERROR";    break;
		case Return.LOCAL_COMM_ERROR:     ErrorString += "ID_LOCALCOMM_ERROR";     break;
		case Return.SPOOLER_NOT_EMPTY:    ErrorString += "ID_SPOOLER_NOT_EMPTY";   break;
		case Return.SESSION_ACTIVE:       ErrorString += "ID_SESSION_ACTIVE";      break;
		case Return.LOCAL_COMM_IN_USE:    ErrorString += "ID_LOCALCOMM_IN_USE";    break;
		case Return.PARAM_ERROR:          ErrorString += "ID_PARAM_ERROR";         break;
		case Return.INVALID_SESSION:      ErrorString += "ID_INVALID_SESSION";     break;
		case Return.MORE_DATA:            ErrorString += "ID_MORE_DATA";           break;
		case Return.INVALID_PRINTER:      ErrorString += "ID_INVALID_PRINTER";     break;
		case Return.INVALID_ACTION:       ErrorString += "ID_INVALID_ACTION";      break;
        case Return.READ_ERROR:           ErrorString += "ID_READ_ERROR";          break;
        case Return.WRITE_ERROR:          ErrorString += "ID_WRITE_ERROR";         break;
        case Return.NO_MAG_DATA:          ErrorString += "ID_NO_MAG_DATA";         break;
		default:                 		  ErrorString += "Unknown SDK Error";      break;
		}

		JOptionPane.showMessageDialog(null, 
									  ErrorString, 
									  "SDK ERROR", 
									  JOptionPane.INFORMATION_MESSAGE);
    }

	//------------------------------------------------------------------------------------

	static byte WaitForPrinterToFinish(HANDLE hSession, SDKlib sdk) {
    	CursorWait();
		
		byte sdkReturn;
		do {
			// Repeat the wait until response is not Timeout
			sdkReturn = sdk.ID_WaitForPrinter(hSession);
		} while (sdkReturn == Return.TIMEOUT);
		
    	CursorDefault();

    	return sdkReturn;
	}

}
